%stochastic gating with bimane and tryptophan with d^3 dependence
clear all
N=500; %number of trials
Nch=1;%number of channels



%******position of Tryptophan*******************
%assume that at peak of barrier is the origin and negative towars closed
%positive toward open, Closed is 10 and open is -10
%lambda is the quenching length
Xi=10;
Xf=-10;
lambda=3;
W=-10;%tryptophan position

%TIME
tstep=0.04;
T=0:tstep:15; %time step
%the divisor larger than 1 allows to see quenching on passing by the W
divisor=1;
time=0:tstep/divisor:15.032;
state(1)=0;
length(T)
tc=tstep;
to=tstep;
%*****here change voltage **************************
 %precalculate the alfa and beta during the total time for voltage time
 %course
for i=1:length(T)
    if(T(i)<1) %before T=5 the sensor is in the closed position because V=-80
        V=-80;
    elseif((T(i)>=1) &&( T(i)<10))
        V=40; %after T=1 V goes to 40 increasing alpha and favoring active postion
    elseif(T(i)>=10)
        V=-80; %after T=7, V goes back to -80
    end
    al(i)=0.0005*exp(V/24);
    be(i)=0.0005*exp(-V/24);
end

%*******************main loop to make mean of N trials*******************
for k=1:N

%initialization of Probabilities
for i=1:length(T)
    P(i,k)=0;
    F(i,k)=0;
end
for i=1:length(T)
    for j=1:Nch
    Pi(i,j)=0;
    Fi(i,j)=0;
    end
end
for i=1:length(time)
    for j=1:Nch
    Pii(i,j)=0;
    Fii(i,j)=0;
    end
end
%velocity
for i=1:length(time)
    
    FF(i,k)=0;
end

  
%internal loop to sum individual channels
for j=1:Nch
   
for i=2:length(T)
    
    if(i==1)
        tc=tstep;
        to=tstep;
    end
     if(state(i-1)==0)
         if(rand>=exp(-(tc)*al(i)))
             state(i)=1;
             tc=tstep;
         else
             state(i)=0;
             tc=tc+tstep;
         end
     else
         if(rand>=exp(-(to)*be(i)))
             state(i)=0;
             to=tstep;
         else
             state(i)=1;
             to=to+tstep;
         end
     end
     
   Pi(i,j)=Pi(i,j)+state(i); 
   
        Fi(i,j)=Pi(i,j)*(1/(1+(lambda/abs(Xi-W))^3)-1/(1+(lambda/abs(Xf-W))^3))+1/(1+(lambda/abs(Xf-W))^3);
        
   if(i>2)
       if(Pi(i,j)==Pi(i-1,j))
           alt=0;
       elseif(Pi(i,j)>Pi(i-1,j))
           alt=1;
       elseif(Pi(i,j)<Pi(i-1,j))
           alt=-1;
       end
      
   kk=0;
   jj=0;
       for ii=divisor*(i-1):divisor*(i-1)+divisor-1
           if(alt==0)
               Fii(ii,j)=Fi(i,j);
           elseif (alt==1)
                kk=kk+1;
                Fii(ii,j)=1/(1+(lambda/(abs(W-(Xi+(Xf-Xi)*kk/divisor))))^3);
                Fii(ii,j)=1/(1+(lambda/(abs(W-(Xf+(Xi-Xf)*kk/divisor))))^3);
           elseif(alt==-1)
               jj=jj+1;
               Fii(ii,j)=1/(1+(lambda/(abs(W-(Xf+(Xi-Xf)*jj/divisor))))^3);
               Fii(ii,j)=1/(1+(lambda/(abs(W-(Xi+(Xf-Xi)*jj/divisor))))^3);
           end
       end
    end     

  
end

%now plot fluorescence


length(Pii)
length(Fii)
length(time)

figure(1)
ylim([-20,20])
if(k<11)
plot(time,2*Fii-20+3*k)
hold on
xlim([0 15])
title('single Fluorescence traces')
end
%figure(3)
%plot(time,Pii(:,1))
end
for i=1:length(T)
    for j=1:Nch
    P(i,k)=P(i,k)+Pi(i,j);
    F(i,k)=F(i,k)+Fi(i,j);
    end
end
%with velocity
for i=1:length(time)
    for j=1:Nch
    
    FF(i,k)=FF(i,k)+Fii(i,j);
    end
end
end

%now compute mean 
%mean
for i=1:length(T)
    Pmean(i)=0;
end
for k=1:N
    for i=1:length(T)
    Pmean(i)=Pmean(i)+P(i,k);
    end
end
for i=1:length(T)
    Pmean(i)=Pmean(i)/N;
end
%mean of fluorescence
for i=1:length(T)
    Fmean(i)=0;
end
for k=1:N
    for i=1:length(T)
    Fmean(i)=Fmean(i)+F(i,k);
    end
end

%now with velocity (when divisor is >1)
for i=1:length(time)
    Fmeani(i)=0;
end
for k=1:N
    for i=1:length(time)
    Fmeani(i)=Fmeani(i)+FF(i,k);
    end
end

for i=1:length(T)
    Fmean(i)=Fmean(i)/N;
end
for i=1:length(time)
    Fmeani(i)=Fmeani(i)/N;
end

%figure(8)
%plot(T,Fmean)
%title('time course of mean Fluorescence ')

figure(2)
plot(time,Fmeani)
title('mean Fluorescence ')
ylim([0 1])
xlim([0 15])   



figure (2)
hold off
figure(1)
hold off

    

         
        
    